 ; Wobble - entity wobbler.
 ; Copyright 1995, 2010 by Rocket Software Ltd.
 ; Custom programming can sometimes save your hide - typically because the
 ; process of writing it gives the bozos in charge time to think.
 (DEFUN C:WOBBLE (/ distp totalp totstr num enampt entt enam typ ccc aaa
                                                                ss ten elv way)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Get a wavelength.
  (if (/= (type dist) 'REAL)
      (setq dist (* dimscl 1.5)))
  (setq distp (getdist (strcat "\nWavelength <" (rtos dist) ">: ")))
  (if distp (setq dist distp))
 ; And a height.
  (if (/= (type hght) 'REAL)
      (setq hght (* dimscl 1.5)))
  (setq hghtp (getdist (strcat "\nAmplitude <" (rtos hght) ">: ")))
  (if hghtp (setq hght hghtp))
 ; Make or redefine the block LL.
  (command "line" "0,0" (list 0 hght) "")
  (if (tblsearch "block" "ll")
      (command "block" "ll" "y" (polar (list 0 0) (/ pi 2) (/ hght 2))
                                                            (entlast) "")
      (command "block" "ll" (polar (list 0 0) (/ pi 2) (/ hght 2))
                                                            (entlast) ""))
  (if (/= (type total) 'INT) (setq total 10))
  (setq totalp (getint (strcat "\nCycles <" (itoa total) ">: ")))
  (if totalp (setq total totalp))
  (setq totstr (strcat "/" (itoa total)))
  (setq num 0)
  (while (< num total)
         (if (null enampt)
             (progn
                  (setq enampt (entsel "\nFrame entity: "))
                  (setq entt (entget (setq enam (car enampt)))))
             (setq enampt (list enam (cdr (assoc 10 (entget enam))))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (if (or (= typ "CIRCLE")
                 (and (= typ "POLYLINE")
                      (= 1 (logand 1 (cdr (assoc 70 (entget enam)))))))
             (setq cl "CL")
             (setq cl "OP"))
         (setq num (1+ num))
         (grtext -2 (strcat (itoa num) totstr))
         (setq typ (cdr (assoc 0 entt)))
 ; Find the last entity in the drawing.
         (setq ccc (setq aaa (entlast)))
         (while (entnext aaa)
                (setq aaa (entnext aaa)))
 ; Insert the guide blocks.
         (command "measure" enampt "b" "ll" "y" dist)
 ; Find and explode resulting block insertions sequentially.
         (setq aaa (entnext aaa))
         (while (= (cdr (assoc 0 (entget aaa))) "INSERT")
                (command "explode" aaa)
                (setq aaa (entnext aaa)))
 ; Now draw the polyline.
         (setq ss (ssadd))
         (command "pline")
         (while (and aaa (/= (cdr (assoc 0 (entget aaa))) "POLYLINE"))
                (ssadd aaa ss)
                (setq entt (entget aaa))
                (setq ten (cdr (assoc 10 entt)))
                (setq elv (cdr (assoc 11 entt)))
                (setq aaa (entnext aaa))
                (if way
                   (progn
                        (setq way ())
                        (command ten)
                        (command elv))
                   (progn
                        (setq way T)
                        (command elv)
                        (command ten))))
         (command "")
 ; Line to use if you need closed polylines, i.e. if wobbling a circle.
  (if (= cl "CL")
      (command "pedit" "l" "s" "C" "")
      (command "pedit" "l" "s" ""))
         (command "erase" ss "")
         (entdel enam)
         (setq enam (entlast)))
  (redraw)
  (command "undo" "end")
 (princ))